########################## Resterampe ##########################

### Ein Korpus von .txt-files vorprozessieren / reinigen und wieder abspeichern
# Arbeitsbereich bereinigen (Housekeeping)
rm(list= ls(all= TRUE))

# Das Paket tm ("Text Mining") aufrufen
library(tm)

name <- file.path("Ausgangsdateien/CorpusKiBueA/") # Verzeichnis mit Textkorpus eintragen
dir(name) # Zeige die Namen der im Verzeichnis enthaltenen Dateien
docs <- Corpus(DirSource(name)) # Erzeuge ein SimpleCorpus 
# SimpleCorpus stellt ein Korpus zur Verfügung, das für das häufigste 
# Anwendungsszenario optimiert ist: Importieren von einfachen Texten aus Dateien 
# in einem Verzeichnis oder direkt aus einem Vektor in R, 
# Vorverarbeitung und Transformation der Texte und schließlich 
# Exportieren in eine Term-Dokument-Matrix.
docs # Zeige an, was im Corpus ist, u.a. Anzahl der Dokumente
# Texttransformation: die Funktion tm_map() wird benutzt, um zum Beispiel 
# Sonderzeichen aus dem Text zu entfernen, indem “/”, “@” and “|” ersetzt werden
toSpace <- content_transformer(function (x , pattern ) gsub(pattern, " ", x))
docs <- tm_map(docs, toSpace, "/")
docs <- tm_map(docs, toSpace, "@")
docs <- tm_map(docs, toSpace, "\\|")
docs <- tm_map(docs, toSpace, "â€”")
docs <- tm_map(docs, toSpace, "—")
docs <- tm_map(docs, toSpace, "«")
docs <- tm_map(docs, toSpace, "»")
docs <- tm_map(docs, toSpace, "„")
docs <- tm_map(docs, toSpace, ">")
docs <- tm_map(docs, toSpace, "<")
docs <- tm_map(docs, toSpace, " ll ")
docs <- tm_map(docs, toSpace, " LL ")
docs <- tm_map(docs, toSpace, " i ")
docs <- tm_map(docs, toSpace, " ii ")
docs <- tm_map(docs, toSpace, " iii ")
docs <- tm_map(docs, toSpace, " iv ")
docs <- tm_map(docs, toSpace, "°")
docs <- tm_map(docs, toSpace, "'")
docs <- tm_map(docs, toSpace, "■")
docs <- tm_map(docs, toSpace, " nnd ")
docs <- tm_map(docs, toSpace, " uud ")
docs <- tm_map(docs, toSpace, " iu ")
docs <- tm_map(docs, toSpace, " nns ")
docs <- tm_map(docs, toSpace, " zn ")
docs <- tm_map(docs, toSpace, " cs ")
docs <- tm_map(docs, toSpace, " III ")
docs <- tm_map(docs, toSpace, " anch ")
docs <- tm_map(docs, toSpace, " vou ")
docs <- tm_map(docs, toSpace, " anf ")
docs <- tm_map(docs, toSpace, " ans ")
docs <- tm_map(docs, toSpace, " mk ")
docs <- tm_map(docs, toSpace, " sic ")
docs <- tm_map(docs, toSpace, " stch ")
docs <- tm_map(docs, toSpace, " dass ")
docs <- tm_map(docs, toSpace, " cant ")
docs <- tm_map(docs, toSpace, " ste ")
docs <- tm_map(docs, toSpace, " do ")
docs <- tm_map(docs, toSpace, " kub ")
docs <- tm_map(docs, toSpace, " frs ")
docs <- tm_map(docs, toSpace, " uus ")
docs <- tm_map(docs, toSpace, " eiu ")
docs <- tm_map(docs, toSpace, " wareu ")
docs <- tm_map(docs, toSpace, " wnrde ")
docs <- tm_map(docs, toSpace, " wnrden ")
docs <- tm_map(docs, toSpace, " unä ")
docs <- tm_map(docs, toSpace, " cd ")

docs <- tm_map(docs, stripWhitespace)

todelete <- content_transformer(function (x , pattern ) gsub(pattern, "", x))
docs <- tm_map(docs, todelete, "•")
docs <- tm_map(docs, todelete, "™")
docs <- tm_map(docs, todelete, "§")
docs <- tm_map(docs, todelete, "*")
docs <- tm_map(docs, todelete, "®")

# Und dann das Ergebnis mit dem Befehl writeCorpus() abspeichern
writeCorpus(docs)

# schreibt tatsächlich alle .txt-Dateien einzeln in das Arbeitsverzeichnis

######## Korpora zwischen verschiedenen Pakete hin- und herkonvertieren
### Von tm nach quanteda

# Die Texte in einem Unterordner mit dem Paket "tm" einlesen
library(tm)
name <- file.path("Ordnername/") # Verzeichnis mit Textkorpus eintragen
length(dir(name)) # Wieviele Textdateien sind in diesem Ordner enthalten?
dir(name) # Zeige die Namen der im Verzeichnis enthaltenen Dateien
corpus_tm <- VCorpus(DirSource(name, encoding = "UTF-8")) # Erzeuge ein VCorpus
# VCorpus steht für Volatile Corpus, eine Standardimplementierung, bei dem das
# Korpus vollständig im Speicher gehalten wird
corpus_tm # Zeige an, was im Corpus ist, u.a. Anzahl der Dokumente

library(quanteda)
# Vcorpus
# quanteda erlaubt es, ein tm VCorpus objekt direkt zu importieren.
corp_quanteda <- corpus(corpus_tm)


### Von quanteda nacht tidytext (benötigt man, wenn vorher 
# z.B. deutsche oder anderssprachige Stopwords entfernt werden sollen)
# Die Texte in einem Unterordner mit readtext einlesen
library(readtext)
library(quanteda)
myCorpus <- readtext("Ordnername/*", encoding = "UTF-8")

# Das Korpus mit quanteda erstellen
TestCorpus <- corpus(myCorpus) 

library(tidytext)
# Das vorhandene tm-Korpus in einen 'tidy'-Datensatz umwandeln
docTidy <- tidy(TestCorpus) 
str(docTidy) # Die Struktur anschauen

### Von tm nach tidytext 
# Das vorhandene tm-VCorpus in einen 'tidy'-Datensatz umwandeln
docTidy <- tidy(corpus_tm) 

# Dieselbe Datenstruktur wie üblich in tidytext herstellen
docTidy <- select(docTidy, id, text)
colnames(docTidy)[1] <- "book"

# und so weiter wie oben ...
# ... evtl. auftauchende Fehlermeldungen
# "Outer names are only allowed for unnamed scalar atomic inputs"
# können ignoriert werden ...


